#include <struct.h>
#include <3dengine.h>

#include "var.h"

/**************************************************************/
//				FUNCTIONS for reading of CHUNKS
/**************************************************************/
BYTE ReadBYTE (CFile &f)
{
	BYTE b;
	f.Read(&b, 1);
	return b;
}
/*----------------------------------------------------------------------------*/
WORD ReadWORD (CFile &f)
{
	WORD w;
	if (2 == f.Read(&w,2))
	  return w;
  return 0;
}
/*----------------------------------------------------------------------------*/
DWORD ReadDWORD (CFile &f)
{
   DWORD l;
   f.Read(&l,4);
   return l;
}
/*----------------------------------------------------------------------------*/
DWORD ReadChunkPointer (CFile &f)
{
	return (ReadDWORD(f));
}
/*----------------------------------------------------------------------------*/
DWORD GetChunkPointer (CFile &f)
{
	return (DWORD)(f.GetPosition() - 2);
}
/*----------------------------------------------------------------------------*/
void ChangeChunkPointer (CFile &f, DWORD offset)
{
	f.Seek(offset, CFile::begin);
}

/*----------------------------------------------------------------------------*/
UINT ReadName (CFile &f, BOOL longName)
{
	UINT teller=0;
	BYTE letter;

	strcpy(temp_name,"Default name");

	letter=ReadBYTE(f);
	if (letter==0) return (-1); // dummy object.........
	temp_name[teller]=letter;
	teller++;
	do
	{
		letter=ReadBYTE(f);
		temp_name [teller]=letter;
		teller++;
	}
	while ((letter!=0) && (longName || (teller < 12)));
	//12 symbols per name (not long).
	temp_name [teller-1]=0;
	return (0);
}


/*----------------------------------------------------------------------------*/
DWORD ReadUnknownChunk (CFile &f, DWORD chunk_id)
{
  if (0 == chunk_id)
    return 0;//don't seek. we are at the end of file.
	DWORD current_pointer;
	DWORD temp_pointer;

	current_pointer=GetChunkPointer(f);
	temp_pointer   =ReadChunkPointer(f);

	ChangeChunkPointer (f,current_pointer+temp_pointer); 
	// move to the new chunk position
	return (temp_pointer);
}

/*----------------------------------------------------------------------------*/
DWORD ReadRGBBYTE (CFile &f, RGBBYTE* rgb)
{
	DWORD res;
	RGBBYTE rgb1, rgb2;
	res = ReadDWORD(f);
	if (res ==24)
	{
		f.Seek(6,CFile::current);
		f.Read(&rgb1 ,sizeof(RGBBYTE));
		f.Seek(6,CFile::current);
		f.Read(&rgb2 ,sizeof(RGBBYTE));
		rgb->r = ((UINT)rgb1.r+(UINT)rgb2.r)/2;
		rgb->g = ((UINT)rgb1.g+(UINT)rgb2.g)/2;
		rgb->b = ((UINT)rgb1.b+(UINT)rgb2.b)/2;
	}
	else
	{
		if (res ==15)
		{
			f.Seek(6,CFile::current);
			f.Read(rgb ,sizeof(RGBBYTE));
		}
		else
			AfxMessageBox("Unknown RGB-COLOR record in material");
	}
	return res;
}


/*----------------------------------------------------------------------------*/
DWORD ReadAmoutOfChunk (CFile &f, WORD* val)
{
	DWORD current_pointer, temp_pointer;
	current_pointer = GetChunkPointer(f);
	temp_pointer	= ReadChunkPointer(f);
	
	WORD res = ReadWORD(f);
	if (res != MAT_MAPAMOUNT)
		AfxMessageBox("Invalid #AmountOf# chunk!");
	else
	{
		ReadDWORD(f);
		*val = ReadWORD(f);
	}
	ChangeChunkPointer (f, current_pointer+temp_pointer);
		// move to the new chunk position
	return (temp_pointer);
}




/*----------------------------------------------------------------------------*/
DWORD ReadVerticesChunk (CFile &f)
{
	DWORD current_pointer, temp_pointer;
	current_pointer=GetChunkPointer (f);
	temp_pointer   =ReadChunkPointer (f);
	numb_vertices  =ReadWORD(f);
	
	if (CurrObject==NULL)
		AfxMessageBox("VERTICES block unexpected!");
	else
	{
		CurrObject->VertTable->Table = new tNormalVertex[numb_vertices];
		CurrObject->VertTable->VertAmount = numb_vertices;
		for (UINT i=0;i < numb_vertices;i++)
		{
			f.Read(&(CurrObject->VertTable->Table[i].X),sizeof(float));
			f.Read(&(CurrObject->VertTable->Table[i].Z),sizeof(float));
			f.Read(&(CurrObject->VertTable->Table[i].Y),sizeof(float));
      CurrObject->VertTable->Table[i].Z*= -1.0f;
		}
	}//ok
  tPOINT center = CurrObject->GetCenterPoint();
  SetMatrixPosition(CurrObject->mTransform, center);

	ChangeChunkPointer (f, current_pointer+temp_pointer); 
	// move to the new chunk position
	return (temp_pointer);
}



/*----------------------------------------------------------------------------*/ 
DWORD ReadFacesMatIndexes(CFile &f)
{
	DWORD	current_pointer, temp_pointer;
	current_pointer=GetChunkPointer(f);
	temp_pointer   =ReadChunkPointer(f);
	DWORD matIndex=0;
	WORD Total, Curr;
	if (CurrObject==NULL)
		AfxMessageBox("FACES MaterialIndex block unexpected!");
	else
	{
		ReadName(f, TRUE);//MaterialName;
		MaterialsList *pList = Materials;
		while ((pList != NULL) && (CString(pList->Name)!=CString(temp_name)))
			pList = pList->Next;
		if (pList!=NULL) matIndex = pList->IndexInZMatSet;

		if (CurrObject->FaceTable->Table!=NULL)
		{//ok
			Total = ReadWORD(f);//amount
			for (UINT i=0; i < Total; i++)
			{//for
				Curr = ReadWORD(f);
				if (Curr < CurrObject->FaceTable->FaceAmount)
					CurrObject->FaceTable->Table[Curr].Material = matIndex;
			}//for
		}//ok
	}
	ChangeChunkPointer (f, current_pointer+temp_pointer); 
	return (temp_pointer);
}
/*----------------------------------------------------------------------------*/ 

DWORD ReadUVChunk(CFile &f)
{
	DWORD	current_pointer, temp_pointer;
	current_pointer=GetChunkPointer(f);
	temp_pointer   =ReadChunkPointer(f);
	if ((CurrObject==NULL) || (CurrObject->FaceTable->Table!=NULL))
		AfxMessageBox("FACES MaterialUV block unexpected!");
	else
	{
		long Total = ReadWORD(f);
		if ((Total==0) || (Total != CurrObject->VertTable->VertAmount))
			AfxMessageBox("UVMapping chunk found but it has invalid length.");
		else
		{//read
			map = new float[Total*2];
			f.Read(map, Total*8);//2*float
			MapSize = Total;
		}//read
	}
	ChangeChunkPointer (f, current_pointer+temp_pointer); 
	return (temp_pointer);
}

/*----------------------------------------------------------------------------*/ 
DWORD ReadSmoothingChunk(CFile &f)
{
	DWORD current_pointer, temp_pointer;

	current_pointer=GetChunkPointer(f);
	temp_pointer   =ReadChunkPointer(f);

	if ((CurrObject==NULL) || (CurrObject->FaceTable->Table==NULL) || (CurrObject->FaceTable->FaceAmount != (long)numb_faces))
		AfxMessageBox("FACES Smoothing block unexpected!");
	else
	{
		for (UINT i=0; i < numb_faces; i++)
			CurrObject->FaceTable->Table[i].SetMiscFlag(0,ReadDWORD(f));
	}
	ChangeChunkPointer (f, current_pointer+temp_pointer); 
	// move to the new chunk position
	return (temp_pointer);
}

/*----------------------------------------------------------------------------*/
DWORD ReadFacesChunk (CFile &f)
{
	DWORD	current_pointer, temp_pointer, Readed;
	WORD	temp_diff;
	UINT	faces [3]; // Diff (Diff= AB: BC: CA: )

	current_pointer=GetChunkPointer(f);

	temp_pointer   =ReadChunkPointer(f);
	numb_faces     =ReadWORD(f);

	if (!CurrObject)
		AfxMessageBox("FACES block unexpected!");
	else
	{
		if (CurrObject->FaceTable->Table!=NULL)
			if (labs(CurrObject->FaceTable->FaceAmount) < labs(numb_faces))
				CurrObject->FaceTable->Table;
		CurrObject->FaceTable->Table = new tFace[numb_faces];
		CurrObject->FaceTable->FaceAmount = numb_faces;
		for (UINT i=0; i < numb_faces; i++)
		{
			CurrObject->FaceTable->Table[i].I1=ReadWORD(f);
			CurrObject->FaceTable->Table[i].I2=ReadWORD(f);
			CurrObject->FaceTable->Table[i].I3=ReadWORD(f);
			temp_diff=ReadWORD(f) & 0x000F;
			faces [0]=(temp_diff & 0x0004) >> 2;
			faces [1]=(temp_diff & 0x0002) >> 1;
			faces [2]=(temp_diff & 0x0001);
//			if (((faces [0]+faces [1]+faces [2]) % 2)==0)
			CurrObject->FaceTable->Table[i].Reorient();
		}
		Readed = 0;
		while (Readed < temp_pointer)
		{
			temp_diff = ReadWORD(f);
			switch (temp_diff)
			{
				case TRI_FACEMAT:
					Readed+=ReadFacesMatIndexes(f);
					break;
				case TRI_SMOOTH:
					Readed+=ReadSmoothingChunk(f);
					break;
				default:
					Readed+=ReadUnknownChunk(f, temp_diff);
			}//switch
			Readed+=2;
		}//while
	}
	ChangeChunkPointer (f, current_pointer+temp_pointer); 
	// move to the new chunk position

	//assigning mapping
	if (map && (MapSize == CurrObject->VertTable->VertAmount))
	{
		for (long i = 0; i < CurrObject->FaceTable->FaceAmount; i++)
		{
			CurrObject->FaceTable->Table[i].U1 = map[CurrObject->FaceTable->Table[i].I1*2];
			CurrObject->FaceTable->Table[i].V1 = 1.0f-map[CurrObject->FaceTable->Table[i].I1*2+1];
			CurrObject->FaceTable->Table[i].U2 = map[CurrObject->FaceTable->Table[i].I2*2];
			CurrObject->FaceTable->Table[i].V2 = 1.0f-map[CurrObject->FaceTable->Table[i].I2*2+1];
			CurrObject->FaceTable->Table[i].U3 = map[CurrObject->FaceTable->Table[i].I3*2];
			CurrObject->FaceTable->Table[i].V3 = 1.0f-map[CurrObject->FaceTable->Table[i].I3*2+1];
		}
		delete[] map;
		map = NULL;
	}

	return (temp_pointer);
}



/*----------------------------------------------------------------------------*/
DWORD ReadObjChunk (CFile &f)
{
	//mapping
	map = NULL;
	MapSize = 0;

	BYTE	end_found=0, boolean=1;
	UINT	temp_int;
	DWORD	current_pointer, temp_pointer,
			tellertje=6L; // 2 id + 4 pointer

	current_pointer=GetChunkPointer (f);
	temp_pointer   =ReadChunkPointer(f);

	while (end_found==0)
	{
		temp_int=ReadWORD(f);
		switch (temp_int)
		{
      case TRI_VERTEXL :
        tellertje+=ReadVerticesChunk(f);
        break;
      case TRI_FACEL1  :
        tellertje+=ReadFacesChunk(f);
        break;
      case TRI_FACEL2  :
        tellertje+=ReadFacesChunk(f);
        break;

      case TRI_LOCAL  :
      case TRI_VISIBLE :
        tellertje+=ReadUnknownChunk(f, temp_int);
        break;
      case TRI_FACEUV:
        tellertje+=ReadUVChunk(f);
        break;
      default:
        //AfxMessageBox(CString("Unknown in MESH at position: ")+Int2String(f.GetPosition()-2));
        tellertje+=ReadUnknownChunk(f, temp_int);
        break;
		}//switch

		tellertje+=2;//WORD ID
		if (tellertje>=temp_pointer)	end_found=1;
	}//while

	ChangeChunkPointer (f, current_pointer+temp_pointer); 
	// move to the new chunk position
	return (temp_pointer);
}

/*----------------------------------------------------------------------------*/
DWORD ReadMAP (CFile &f, MapDescriptor* pmap)
{
	BYTE	end_found=0;
	UINT	temp_int;
	DWORD	current_pointer, temp_pointer,
			tellertje=6L; // 2 id + 4 pointer
	DWORD	NameLen;

	current_pointer=GetChunkPointer(f);
	temp_pointer   =ReadChunkPointer(f);
	while (end_found==0)
	{
		temp_int=ReadWORD(f);
		switch (temp_int)
		{
			case MAT_MAPFILE	://filename
				NameLen = ReadDWORD(f);
				f.Read(&(pmap->Filename), NameLen);
				tellertje+=NameLen +4; //4 is sizeof(DWORD);
				break;
			case MAT_MAPAMOUNT	:
			case MAT_MAPOPT		:
			case MAT_MAPFILTER	:
				tellertje+=ReadUnknownChunk(f,temp_int);
				break;
			
        default: tellertje+=ReadUnknownChunk(f,temp_int);break;
		}
		tellertje+=2;
		if (tellertje>=temp_pointer) end_found=1;
	}
	ChangeChunkPointer (f, current_pointer+temp_pointer);
	return (temp_pointer);
}




/*----------------------------------------------------------------------------*/
DWORD ReadObjectChunk (CFile &f, tObjectSet* Objects)
{
	BYTE	end_found=0;
	UINT	temp_int;
	DWORD	current_pointer, temp_pointer,
			tellertje=6L; // 2 id + 4 pointer

	current_pointer=GetChunkPointer(f);
	temp_pointer   =ReadChunkPointer(f);
	CurrObject = new tObject();

	if (ReadName(f, FALSE)==-1)
		strcpy(CurrObject->ObjectName, Objects->GetSequentalName("UnNamed#"));
	else
  {
		strcpy(CurrObject->ObjectName, temp_name);
    tellertje+=strlen(temp_name); //+1?
  }

	while (end_found==0)
	{
		temp_int=ReadWORD(f);
		switch (temp_int)
		{
      case OBJ_TRIMESH :
			  tellertje+=ReadObjChunk(f);
			  break;
      case OBJ_LIGHT   :
      case OBJ_CAMERA  :
		  case OBJ_UNKNWN01:
      case OBJ_UNKNWN02:
      default:
        tellertje+=ReadUnknownChunk(f,temp_int);
        break;
		}
		tellertje+=2;
		if (tellertje>=temp_pointer) end_found=1;
	}
	/***********************************/
	//	ADD THIS OBJECT To The SET!!!!!!!!
	if ((CurrObject!=NULL) && (CurrObject->VertTable->VertAmount>0)&& (CurrObject->FaceTable->FaceAmount>0))
	{
		CurrObject->VertTable->SelectAll();
		CurrObject->CalculateNormals(FALSE, TRUE, TRUE);
		CurrObject->NormalizeNormals(FALSE, TRUE);
		CurrObject->VertTable->UnSelectAll();
    CurrObject->nRequire = Z3D_PLUGRESULT_REDRAW;
		Objects->AddObject(CurrObject);
	}
	delete CurrObject;
	
	CurrObject = new tObject();

	/************************************/
	// move to the new chunk position
  if (tellertje != temp_pointer)
	  ChangeChunkPointer (f, current_pointer+temp_pointer);

	return (temp_pointer);
}



/*----------------------------------------------------------------------------*/
DWORD ReadMaterialChunk (CFile &f, CDirect3D* d3d)
{
	BYTE	end_found=0;
	UINT	temp_int;
	DWORD	current_pointer, temp_pointer,
			tellertje=6L;
	DWORD	currsubptr, tempsubptr;
	int		TotalChunks =0;

	current_pointer=GetChunkPointer (f);
	temp_pointer   =ReadChunkPointer(f);

	while (end_found==0)
	{
		temp_int=ReadWORD(f);
		switch (temp_int)
		{
        case MAT_NAME01		:
		/**** Reading material Name ****/
			currsubptr = GetChunkPointer (f);
			tempsubptr = ReadChunkPointer(f);
			if (ReadName(f, TRUE)==-1)
			{//default material
				strcpy(Materials->Name,"<Default Material>");
				Materials->IndexInZMatSet = 0L;
			}
			else
				strcpy(Materials->Name, temp_name);
			ChangeChunkPointer (f, currsubptr+tempsubptr);
			//tellertje+=ReadMatDefChunk(f);
			tellertje+=tempsubptr;
			TotalChunks++;
			break;
		case MAT_AMBIENT	:
			/**** Reading material AMBIENT ****/
			tellertje+=ReadRGBBYTE(f, &Materials->mat.AmbiCol);
			TotalChunks++;
			break;
		case MAT_DIFFUSE	:
			/**** Reading material DIFFUSE ****/
			tellertje+=ReadRGBBYTE(f, &Materials->mat.DiffCol);
			TotalChunks++;
			break;
		case MAT_SPECULAR	:
			/**** Reading material SPECULAR ****/
			tellertje+=ReadRGBBYTE(f, &Materials->mat.SpecCol);
			TotalChunks++;
			break;
		case MAT_SHININESS	:
			tellertje+=ReadAmoutOfChunk(f, &Materials->mat.Shine);
			TotalChunks++;
			break;
		case MAT_SHINSTEN	:
			tellertje+=ReadAmoutOfChunk(f, &Materials->mat.ShinStren);
			TotalChunks++;
			break;
		case MAT_TRANSPAR	:
			tellertje+=ReadAmoutOfChunk(f, &Materials->mat.Transpar);
			TotalChunks++;
			break;
		case MAT_TRANSFALL	:
			tellertje+=ReadAmoutOfChunk(f, &Materials->mat.TransFalloff);
			TotalChunks++;
			break;
		case MAT_REFLECT	:
			tellertje+=ReadAmoutOfChunk(f, &Materials->mat.Reflect);
			TotalChunks++;
			break;
		case MAT_SELFILLUM	:
			tellertje+=ReadAmoutOfChunk(f, &Materials->mat.SelfIllum);
			TotalChunks++;
			break;
		case MAT_TXT1_MAP	:
			tellertje+=ReadMAP(f, &Materials->mat.Textur1Map);
			TotalChunks++;
			break;
		case MAT_BUMP_MAP	:
			tellertje+=ReadMAP(f, &Materials->mat.BumpMap);
			TotalChunks++;
			break;
		case MAT_REFL_MAP	:
			tellertje+=ReadMAP(f, &Materials->mat.RefMap);
			TotalChunks++;
			break;
		default:
			tellertje+=ReadUnknownChunk(f, temp_int);
		}//switch
	tellertje+=2;
	if (tellertje>=temp_pointer)
		end_found=1;
	}//while

	/********** add the current Material to the CDirect3D set **********/
	Materials->IndexInZMatSet = 
		d3d->CreateMaterial(
			(float)(Materials->mat.AmbiCol.r+Materials->mat.DiffCol.r)/512.0f,//256*3
			(float)(Materials->mat.AmbiCol.g+Materials->mat.DiffCol.g)/512.0f,
			(float)(Materials->mat.AmbiCol.b+Materials->mat.DiffCol.b)/512.0f,
			1.0f-(float)(Materials->mat.Transpar)/(float)(100), //default alpha
			(float)(Materials->mat.ShinStren)/100.0f,	//[0.0..1.0]
			(float)(Materials->mat.Shine),				//[0.0..100.0]

			(char*)&(Materials->mat.Textur1Map.Filename),
			(char*)&(Materials->mat.BumpMap.Filename),
			(char*)&(Materials->mat.RefMap.Filename),
			"",
			(char*)&(Materials->Name),
			0x00000000,
			D3DTOP_MODULATE,
			D3DTOP_DISABLE,
			D3DTOP_ADD,
			D3DTOP_DISABLE,
			D3DBLEND_SRCALPHA,
			D3DBLEND_INVSRCALPHA,
			1,//glowing (if any)
			0x80,
			(BYTE)D3DCMP_ALWAYS);

	/********** add the current Material to the CDirect3D set **********/

	ChangeChunkPointer (f, current_pointer+temp_pointer); 
	// move to the new chunk position
	return (temp_pointer);
}


DWORD AddMaterial(CFile &f, CDirect3D* d3d)
{
	MaterialsList *currMat;
	currMat = new MaterialsList;
	currMat ->Next = Materials;
	Materials = currMat;
	
	DWORD res = ReadMaterialChunk(f, d3d);
	return res;
}


/*----------------------------------------------------------------------------*/
DWORD ReadEditChunk (CFile &f, tObjectSet* Objects, CDirect3D*  d3d)
{
	BYTE end_found=0;
	UINT temp_int;
	DWORD	current_pointer, temp_pointer,
			tellertje=6L;

	current_pointer=GetChunkPointer (f);
	temp_pointer   =ReadChunkPointer(f);

	while (end_found==0)
	{
		temp_int=ReadWORD(f);
		switch (temp_int)
		{
			case EDIT_UNKNW01:
			case EDIT_UNKNW02:
			case EDIT_UNKNW03:
			case EDIT_UNKNW04:
			case EDIT_UNKNW05:
			case EDIT_UNKNW06:
			case EDIT_UNKNW07:
			case EDIT_UNKNW08:
			case EDIT_UNKNW09:
			case EDIT_UNKNW10:
			case EDIT_UNKNW11:
			case EDIT_UNKNW12:
			case EDIT_UNKNW13:
			case EDIT_VIEW1  :
			case EDIT_BACKGR :
			case EDIT_AMBIENT:
				tellertje+=ReadUnknownChunk(f, temp_int);
				break;
			case EDIT_MATERIAL :
			{
				tellertje+=AddMaterial(f, d3d);
				break;
			}
			case EDIT_OBJECT:
			{
				tellertje+=ReadObjectChunk(f, Objects);
				break;
			}
			default:
//				AfxMessageBox(CString("Unknown in ReadEditChunk at position: ")+Int2String(f.GetPosition()-2));
				tellertje+=ReadUnknownChunk(f, temp_int);
				break;
		}//switch

		tellertje+=2;
		if (tellertje>=temp_pointer)	end_found=1;
	}//while

	ChangeChunkPointer (f, current_pointer+temp_pointer); 
	// move to the new chunk position
	return (temp_pointer);
}




/*----------------------------------------------------------------------------*/
DWORD ReadMainChunk (CFile &f, tObjectSet* Objects, CDirect3D*  d3d)
{
	BYTE end_found=0;
	UINT temp_int;
	DWORD	current_pointer, temp_pointer,
			tellertje=6L;

	current_pointer=GetChunkPointer (f);
	temp_pointer   =ReadChunkPointer(f);

	while (end_found==0)
	{
		temp_int=ReadWORD(f);
		switch (temp_int)
		{
		case KEYF3DS:
      tellertje+=ReadUnknownChunk(f, temp_int);
			break;
    case EDIT3DS :
			tellertje+=ReadEditChunk(f, Objects, d3d);
			break;
    default:
///			AfxMessageBox(CString("Unknown in ReadMainChunk at position: ")+Int2String(f.GetPosition()-2));
			tellertje+=ReadUnknownChunk(f, temp_int);
		break;
		}//switch
		tellertje+=2;
		if (tellertje>=temp_pointer)
			end_found = 1;
	}//while

	ChangeChunkPointer (f, current_pointer+temp_pointer);
	// move to the new chunk position
	return (temp_pointer);
}



/*----------------------------------------------------------------------------*/
WORD ReadPrimaryChunk (CWnd *pwnd, CFile &f, tObjectSet* Objects, CDirect3D*  d3d)
{
	BYTE version;

	WORD w = ReadWORD(f);
	if (w==MAIN3DS)
	{
		f.Seek (22L,CFile::begin);
		w=ReadWORD(f);
		if ((w == EDIT_VERSION1) || (w == EDIT_VERSION2))
		{
			f.Seek (28L,CFile::begin);
			version=ReadBYTE(f);
			if ((version<3))
			{
				if (IDYES!=ShowFailMessage(
						pwnd,
						"Can not read the specified file",
						"wrong version number.\nThe filter might try to import the meshes anyway.\n"
						"Want to continue?",
						MB_ICONQUESTION| MB_YESNO))
					return (1);
			}
			f.Seek (2,CFile::begin);
			ReadMainChunk(f, Objects, d3d);
		}
		else
		{//simplifided file
			f.Seek (2,CFile::begin);
			ReadEditChunk(f, Objects, d3d);
		}
		
		
	}
	else
	{
		if (w==EDIT3DS)
			ReadEditChunk(f, Objects, d3d);
		return (1);
	}

	return (0);
}



/**************************************************************/
//			3DS File Importer to Zanoza 3D Editor
/**************************************************************/
DWORD CALLBACK Import(	CString fromfile,
						CWnd *pwnd,
						tObjectSet* Objects,
						tUnDataSet* UnData,
						CDirect3D*  d3d,
						SYSTEMREQUESTPROC RequestProc,
						HINSTANCE AppHIns,
						HINSTANCE DllHIns
						)
{
	CFile InFile;
	MaterialsList *tmpMat = NULL;

	if (!InFile.Open(fromfile, CFile::modeRead))
	{
		//ERROR
		ShowFailMessage(pwnd, "Can not open the specified file", "invalid file attributes", MB_ICONEXCLAMATION);
		return 0;
	}
	
	CString path = InFile.GetFilePath();
	int pos = path.ReverseFind('\\');
	if (pos > 0)
	{//add this files' path to textures search paths set
		path = path.Left(pos);
		d3d->Materials.Textures->AddPath(path.GetBuffer(path.GetLength()));
	}
	
//	CurrObject = new tObject();
	while (ReadPrimaryChunk (pwnd, InFile, Objects, d3d)==0)
	;//empty loop
	
	/*********** erasing Materials list ***********/
	tmpMat = Materials;
	while (tmpMat != NULL)
	{
		Materials = Materials->Next;
		delete tmpMat;
		tmpMat = Materials;
	}

	if (CurrObject)
		delete CurrObject;

	return 1;
}
/*----------------------------------------------------------------------------*/
